/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.regionalsettings.RegionalSettings;
import cz.insophy.inplan.util.regionalsettings.StringParserRegionSettings;
import cz.insophy.inplan.util.regionalsettings.XmlRegionalSettings;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringParser {
    private static final Splitter FUZZY_TIME_SPLITTER = Splitter.onPattern("[.:]");
    private static final ThreadLocal<String> regionId = ThreadLocal.withInitial(() -> "cs");
    private static Map<String, StringParserRegionSettings> formats = StringParser.regionsToFormats(new RegionalSettings().createLegacyRegions());

    private StringParser() {
        throw new UnsupportedOperationException();
    }

    public static void setRegions(XmlRegionalSettings regions) {
        formats = StringParser.regionsToFormats(regions);
    }

    @Nonnull
    private static Map<String, StringParserRegionSettings> regionsToFormats(XmlRegionalSettings regions) {
        return regions.getRegion().stream().collect(Collectors.toMap(XmlRegionalSettings.Region::getId, StringParserRegionSettings::new));
    }

    public static void setRegionId(@Nonnull String newRegionId) {
        Preconditions.checkNotNull(regionId);
        if (!newRegionId.equals(regionId.get())) {
            regionId.set(newRegionId);
        }
    }

    private static StringParserRegionSettings getFormats() {
        return formats.get(regionId.get());
    }

    @Nullable
    public static Number parseNumber(@Nonnull String value) {
        Preconditions.checkNotNull(value);
        ParsePosition pp = new ParsePosition(0);
        Number res = Formatter.getFormats().getNumberFormat().parse(value, pp);
        if (pp.getIndex() != value.length()) {
            res = null;
        }
        return res;
    }

    public static TimeSpan parseTimeFuzzy(@Nonnull String value) {
        TimeSpan res;
        List<String> parts = FUZZY_TIME_SPLITTER.splitToList(value);
        long[] lens = new long[]{3600000L, 60000L, 1000L};
        try {
            long start = 0L;
            start -= (long)TimeZone.getDefault().getOffset(start);
            switch (parts.size()) {
                case 3: {
                    start += (long)Integer.parseInt(parts.get(2)) * 1000L;
                }
                case 2: {
                    start += (long)Integer.parseInt(parts.get(1)) * 60000L;
                }
                case 1: {
                    break;
                }
                default: {
                    return null;
                }
            }
            long end = (start += (long)Integer.parseInt(parts.get(0)) * 3600000L) + lens[parts.size() - 1];
            res = TimeSpan.fromStartEnd(start, end);
        }
        catch (NumberFormatException e) {
            res = null;
        }
        return res;
    }

    @Nullable
    public static TimeSpan parseDateFuzzy(@Nonnull String value) {
        value = StringParser.cleanupDatetime(value);
        List<DtParser> dateParsers = StringParser.getFormats().getFuzzyDateParsers();
        ParsePosition pp = new ParsePosition(0);
        for (DtParser dateParser : dateParsers) {
            LocalDate d = dateParser.parseLocalDateFromStart(value, pp);
            if (d == null) continue;
            String rest = value.substring(pp.getIndex()).stripLeading();
            if (rest.isEmpty()) {
                return StringParser.toTimeSpan(d.atStartOfDay(), dateParser.length);
            }
            if (!dateParser.canTimeFollow()) continue;
            List<DtParser> timeParsers = StringParser.getFormats().getFuzzyTimeParsers();
            for (DtParser timeParser : timeParsers) {
                LocalTime t = timeParser.parseLocalTimeFromStart(rest, pp);
                if (t == null || pp.getIndex() != rest.length()) continue;
                return StringParser.toTimeSpan(d.atTime(t), timeParser.length);
            }
        }
        Number n = StringParser.parseNumber(value);
        if (n != null) {
            int x = n.intValue();
            try {
                if (x >= 1900) {
                    return StringParser.toTimeSpan(LocalDateTime.of(x, 1, 1, 0, 0), Period.ofYears(1));
                }
                return StringParser.toTimeSpan(LocalDate.now(ZoneId.systemDefault()).withDayOfMonth(x).atStartOfDay(), Period.ofDays(1));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    public static Optional<DurationParseResult> parseDuration(@Nonnull String value, @Nonnull Formatter.DurationStyle durationStyle) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull(durationStyle);
        switch (durationStyle) {
            case NORMAL: 
            case DETAIL: 
            case COMPACT: 
            case DAY_HOUR: {
                return StringParser.parseDurationComplex(value);
            }
            case DAY: {
                Number days = StringParser.parseDurationNumberValue(value);
                return days == null ? Optional.empty() : Optional.of(new DurationParseResult(Duration.ofMillis(Double.valueOf(days.doubleValue() * 8.64E7).longValue()), ChronoUnit.MILLIS));
            }
            case HOUR: 
            case NH: {
                Number hours = StringParser.parseDurationNumberValue(value);
                return hours == null ? Optional.empty() : Optional.of(new DurationParseResult(Duration.ofMillis(Double.valueOf(hours.doubleValue() * 3600000.0).longValue()), ChronoUnit.MILLIS));
            }
        }
        throw new IllegalStateException();
    }

    private static Number parseDurationNumberValue(@Nonnull String value) {
        try {
            return Formatter.getFormats().getNumberDurationFormat().parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nonnull
    private static Optional<DurationParseResult> parseDurationComplex(@Nonnull String value) {
        String d = Formatter.getSymbols().getDays().toLowerCase().trim();
        String h2 = Formatter.getSymbols().getHours().toLowerCase().trim();
        String m3 = Formatter.getSymbols().getMinutesShort().toLowerCase().trim();
        ParsePosition pp = new ParsePosition(0);
        Duration dur = Duration.ZERO;
        ChronoUnit unit = ChronoUnit.DAYS;
        int parsedPartsCnt = 0;
        while (pp.getIndex() < value.length()) {
            while (pp.getIndex() < value.length() && Character.isWhitespace(value.charAt(pp.getIndex()))) {
                pp.setIndex(pp.getIndex() + 1);
            }
            int start = pp.getIndex();
            Number n = Formatter.getFormats().getNumberFormat().parse(value, pp);
            if (start < pp.getIndex()) {
                while (pp.getIndex() < value.length() && Character.isWhitespace(value.charAt(pp.getIndex()))) {
                    pp.setIndex(pp.getIndex() + 1);
                }
                String rest = value.substring(pp.getIndex());
                if (rest.startsWith(d) || rest.isEmpty()) {
                    pp.setIndex(pp.getIndex() + d.length());
                    dur = dur.plus(n.longValue(), ChronoUnit.DAYS);
                } else if (rest.startsWith(h2)) {
                    pp.setIndex(pp.getIndex() + h2.length());
                    dur = dur.plus(n.longValue(), ChronoUnit.HOURS);
                    if (unit.getDuration().compareTo(ChronoUnit.HOURS.getDuration()) > 0) {
                        unit = ChronoUnit.HOURS;
                    }
                } else if (rest.startsWith(m3)) {
                    pp.setIndex(pp.getIndex() + m3.length());
                    dur = dur.plus(n.longValue(), ChronoUnit.MINUTES);
                    if (unit.getDuration().compareTo(ChronoUnit.MINUTES.getDuration()) > 0) {
                        unit = ChronoUnit.MINUTES;
                    }
                } else {
                    return Optional.empty();
                }
                ++parsedPartsCnt;
                continue;
            }
            return Optional.empty();
        }
        return parsedPartsCnt > 0 ? Optional.of(new DurationParseResult(dur, unit)) : Optional.empty();
    }

    @Nullable
    public static TimeSpan parseTimeRelative(@Nonnull String s2, long ref) {
        Preconditions.checkNotNull(s2, "string in parseTimeRelative");
        if (s2.isEmpty()) {
            return null;
        }
        int dir = 1;
        if (s2.charAt(0) == '-') {
            s2 = s2.substring(1);
            dir = -1;
        } else if (s2.charAt(0) == '+') {
            s2 = s2.substring(1);
        }
        if (s2.isEmpty()) {
            return null;
        }
        Optional<DurationParseResult> durRes = StringParser.parseDuration(s2, Formatter.DurationStyle.DETAIL);
        if (durRes.isEmpty()) {
            return null;
        }
        Duration dur = durRes.get().getDuration().multipliedBy(dir);
        TemporalUnit unit = durRes.get().getUnit();
        ZonedDateTime start = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ref), ZoneId.systemDefault()).plus(dur).truncatedTo(unit);
        ZonedDateTime end = start.plus(1L, unit);
        return TimeSpan.fromStartEnd(start.toInstant().toEpochMilli(), end.toInstant().toEpochMilli());
    }

    public static Long parseExcelLong(@Nonnull String s2) throws IllegalArgumentException {
        try {
            return Long.valueOf(s2);
        }
        catch (Exception exception) {
            long d2;
            ParsePosition pos;
            try {
                pos = new ParsePosition(0);
                d2 = StringParser.getFormats().getExcelDefaultWholeNumberFormat().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d2) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                d2 = StringParser.getFormats().getExcelFormattedWholeNumberFormat().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d3) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                long d4 = StringParser.getFormats().getExcelDefaultDecimalNumberFormat().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d4;
                }
            }
            catch (Exception d4) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                long d5 = StringParser.getFormats().getExcelFormattedDecimalNumberFormat().parse(s2, pos).longValue();
                if (pos.getIndex() == s2.length()) {
                    return d5;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new IllegalArgumentException();
        }
    }

    public static Double parseExcelDouble(@Nonnull String s2) throws IllegalArgumentException {
        try {
            return Double.valueOf(s2);
        }
        catch (Exception exception) {
            double d2;
            ParsePosition pos;
            try {
                pos = new ParsePosition(0);
                d2 = StringParser.getFormats().getExcelDefaultDecimalNumberFormat().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d2) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                d2 = StringParser.getFormats().getExcelFormattedDecimalNumberFormat().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d2;
                }
            }
            catch (Exception d3) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                double d4 = StringParser.getFormats().getExcelDefaultWholeNumberFormat().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d4;
                }
            }
            catch (Exception d4) {
                // empty catch block
            }
            try {
                pos = new ParsePosition(0);
                double d5 = StringParser.getFormats().getExcelFormattedWholeNumberFormat().parse(s2, pos).doubleValue();
                if (pos.getIndex() == s2.length()) {
                    return d5;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new IllegalArgumentException();
        }
    }

    private static TimeSpan toTimeSpan(LocalDateTime dt, TemporalAmount length) {
        ZonedDateTime start = dt.atZone(ZoneId.systemDefault());
        ZonedDateTime end = start.plus(length);
        return TimeSpan.fromStartEnd(start.toInstant().toEpochMilli(), end.toInstant().toEpochMilli());
    }

    @VisibleForTesting
    static String cleanupDatetime(@Nonnull String value) {
        StringBuilder sb = new StringBuilder();
        int state = 1;
        block5: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) {
                        state = 1;
                    } else if (StringParser.isDatetimeSeparator(ch)) {
                        state = 2;
                    }
                    sb.append(ch);
                    continue block5;
                }
                case 1: {
                    if (StringParser.isDatetimeSeparator(ch)) {
                        if (sb.length() == 0) continue block5;
                        sb.setLength(sb.length() - 1);
                        state = 2;
                        sb.append(ch);
                        continue block5;
                    }
                    if (Character.isWhitespace(ch)) continue block5;
                    state = 0;
                    sb.append(ch);
                    continue block5;
                }
                case 2: {
                    if (Character.isWhitespace(ch)) continue block5;
                    state = 0;
                    sb.append(ch);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("state " + i);
                }
            }
        }
        if (state == 1 && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static boolean isDatetimeSeparator(char ch) {
        return ch == '.' || ch == ':' || ch == '/' || ch == '-';
    }

    public static class DtParser {
        final DateTimeFormatter formatter;
        final TemporalAmount length;

        public DtParser(String pattern, Locale loc, TemporalAmount length) {
            this.formatter = DateTimeFormatter.ofPattern(pattern, loc);
            this.length = length;
        }

        boolean canTimeFollow() {
            return this.length.equals(Period.ofDays(1));
        }

        @Nullable
        <T> T parseFromStart(String value, ParsePosition pp, TemporalQuery<T> x) {
            pp.setIndex(0);
            pp.setErrorIndex(-1);
            TemporalAccessor ta = this.formatter.parseUnresolved(value, pp);
            if (pp.getErrorIndex() >= 0) {
                return null;
            }
            try {
                return x.queryFrom(ta);
            }
            catch (DateTimeException e) {
                return null;
            }
        }

        private static LocalDate toLocalDate(TemporalAccessor ta) {
            LocalDate now = LocalDate.now(ZoneId.systemDefault());
            int y = ta.isSupported(ChronoField.YEAR) ? ta.get(ChronoField.YEAR) : now.getYear();
            int m3 = ta.isSupported(ChronoField.MONTH_OF_YEAR) ? ta.get(ChronoField.MONTH_OF_YEAR) : now.getMonthValue();
            int d = ta.isSupported(ChronoField.DAY_OF_MONTH) ? ta.get(ChronoField.DAY_OF_MONTH) : 1;
            return LocalDate.of(y, m3, d);
        }

        private static LocalTime toLocalTime(TemporalAccessor ta) {
            int h2 = ta.isSupported(ChronoField.HOUR_OF_DAY) ? ta.get(ChronoField.HOUR_OF_DAY) : 0;
            int m3 = ta.isSupported(ChronoField.MINUTE_OF_HOUR) ? ta.get(ChronoField.MINUTE_OF_HOUR) : 0;
            int s2 = ta.isSupported(ChronoField.SECOND_OF_MINUTE) ? ta.get(ChronoField.SECOND_OF_MINUTE) : 0;
            int n = ta.isSupported(ChronoField.NANO_OF_SECOND) ? ta.get(ChronoField.NANO_OF_SECOND) : 0;
            return LocalTime.of(h2, m3, s2, n);
        }

        LocalDate parseLocalDateFromStart(String value, ParsePosition pp) {
            return this.parseFromStart(value, pp, DtParser::toLocalDate);
        }

        LocalTime parseLocalTimeFromStart(String value, ParsePosition pp) {
            return this.parseFromStart(value, pp, DtParser::toLocalTime);
        }
    }

    public static class DurationParseResult {
        private final Duration duration;
        private final TemporalUnit unit;

        @VisibleForTesting
        DurationParseResult(@Nonnull Duration duration, @Nonnull TemporalUnit unit) {
            this.duration = Preconditions.checkNotNull(duration);
            this.unit = Preconditions.checkNotNull(unit);
        }

        public Duration getDuration() {
            return this.duration;
        }

        public TemporalUnit getUnit() {
            return this.unit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DurationParseResult)) {
                return false;
            }
            DurationParseResult that = (DurationParseResult)o;
            return this.duration.equals(that.duration) && this.unit.equals(that.unit);
        }

        public int hashCode() {
            return Objects.hash(this.duration, this.unit);
        }

        public String toString() {
            return new StringJoiner(", ", DurationParseResult.class.getSimpleName() + "[", "]").add("duration=" + this.duration).add("unit=" + this.unit).toString();
        }
    }
}

